local res = external_profile("Config/Input/Aircrafts/common_joystick_binding.lua")
local cockpit = folder.."../../../Cockpit/"
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")

join(res.keyCommands,{

    -- Joystick switch abstractions (Example, ON else OFF)
    {down = fcs_commands.Switch_FLAP_SELECT,    up = fcs_commands.Switch_FLAP_SELECT,   cockpit_device_id=devices.VREST,            value_down=1.0, value_up=0.5,   name = _('Flaps CRUISE else AUTO'),				category = _('Joystick Switch Abstractions')},
    {down = fcs_commands.Switch_FLAP_SELECT,    up = fcs_commands.Switch_FLAP_SELECT,   cockpit_device_id=devices.VREST,            value_down=0.0, value_up=0.5,   name = _('Flaps STOL else AUTO'),				category = _('Joystick Switch Abstractions')},    
    {down = fcs_commands.Switch_ANTISKID,       up = fcs_commands.Switch_ANTISKID,      cockpit_device_id=devices.FLIGHTCONTROLS,   value_down=0.0, value_up=0.5,   name = _('Anti-Skid NWS else ON'),				category = _('Joystick Switch Abstractions')},
    {down = smc_commands.Switch_Master_Arm,     up = smc_commands.Switch_Master_Arm,    cockpit_device_id=devices.SMC,              value_down=1.0, value_up=0.0,   name = _('MasterArm ON else OFF'),				category = _('Joystick Switch Abstractions')},
    {down = engine_commands.Switch_H20,         up = engine_commands.Switch_H20,        cockpit_device_id=devices.DECS,             value_down=1.0, value_up=0.5,   name = _('H2O TO else OFF'),					category = _('Joystick Switch Abstractions')},
    {down = engine_commands.Switch_H20,         up = engine_commands.Switch_H20,        cockpit_device_id=devices.DECS,             value_down=0.0, value_up=0.5,   name = _('H2O LN else OFF'),					category = _('Joystick Switch Abstractions')},        
    {down = iCommandPlaneGearUp,                up = iCommandPlaneGearDown,     																					name = _('Landing Gear UP else DOWN'),			category = _('Joystick Switch Abstractions')},
	{down = fcs_commands.Handle_PARKING_BRAKE,  up = fcs_commands.Handle_PARKING_BRAKE, cockpit_device_id=devices.FLIGHTCONTROLS,	value_down=1.0, value_up=0.0,	name = _('Parking Brake Lever OFF else ON'),	category = _('Joystick Switch Abstractions')},
	
	-- Master Modes
	{down = iCommandHelicopter_PPR_button_K, name = _('Master Mode NAV'),	category = _('Master Modes')},
	{down = iCommandHelicopter_PPR_button_H, name = _('Master Mode VSTOL'),	category = _('Master Modes')},
	{down = iCommandHelicopter_PPR_button_T, name = _('Master Mode AG'),	category = _('Master Modes')},
	
	-- HUD Controls
	{down = iCommandPlane_ABRIS_BT_1,		name = _('HUD Reject Mode Down (NORM - REJ1 - REJ2)'),	category = _('HUD Control')},
	{down = iCommandPlane_ABRIS_BT_2,		name = _('HUD Reject Mode Up (REJ2 - REJ1 - NORM)'),	category = _('HUD Control')},
	{down = iCommandPlane_ABRIS_BT_3,		name = _('HUD Display Mode Down DAY - AUTO - NIGHT'),	category = _('HUD Control')},
	{down = iCommandPlane_ABRIS_BT_5,		name = _('HUD Display Mode Up NIGHT - AUTO - DAY'),		category = _('HUD Control')},
	{down = iCommandPlane_ABRIS_BT_4,		name = _('HUD Altitude Selector'),						category = _('HUD Control')},
	{pressed = iCommandHUDBrightnessUp,		up = iCommandHUDTest_up,	name = _('HUD On - Brightness Increase'),	category = _('HUD Control')},
	{pressed = iCommandHUDBrightnessDown,	up = iCommandHUDTest_up,	name = _('HUD Brightness Decrease - Off'),	category = _('HUD Control')},
	{down = hud_commands.RejectSwitch,					cockpit_device_id = devices.HUDCONTROL, value_down = 0.0, name = _('HUD Reject Switch NORM'), category = _('HUD Control')},
	{down = hud_commands.RejectSwitch,					cockpit_device_id = devices.HUDCONTROL, value_down = 0.5, name = _('HUD Reject Switch REJ1'), category = _('HUD Control')},
	{down = hud_commands.RejectSwitch,					cockpit_device_id = devices.HUDCONTROL, value_down = 1.0, name = _('HUD Reject Switch REJ2'), category = _('HUD Control')},
	{down = hud_commands.RejectSwitch_REJ1_TOGGLE,		cockpit_device_id = devices.HUDCONTROL, value_down = 0.0, name = _('HUD Reject Switch REJ1/NORM'), category = _('HUD Control')},
	{down = hud_commands.RejectSwitch_REJ2_TOGGLE,		cockpit_device_id = devices.HUDCONTROL, value_down = 0.0, name = _('HUD Reject Switch REJ2/NORM'), category = _('HUD Control')},
	{down = hud_commands.DisplayModeSwitch,				cockpit_device_id = devices.HUDCONTROL, value_down = 0.0, name = _('HUD Display Mode DAY'), category = _('HUD Control')},
	{down = hud_commands.DisplayModeSwitch,				cockpit_device_id = devices.HUDCONTROL, value_down = 0.5, name = _('HUD Display Mode AUTO'), category = _('HUD Control')},
	{down = hud_commands.DisplayModeSwitch,				cockpit_device_id = devices.HUDCONTROL, value_down = 1.0, name = _('HUD Display Mode NIGHT'), category = _('HUD Control')},
	{down = hud_commands.DisplayModeSwitch_NIGHT_TOGGLE,cockpit_device_id = devices.HUDCONTROL, value_down = 0, name = _('HUD Display Mode NIGHT/AUTO'), category = _('HUD Control')},
	{down = hud_commands.DisplayModeSwitch_DAY_TOGGLE,	cockpit_device_id = devices.HUDCONTROL, value_down = 0, name = _('HUD Display Mode DAY/AUTO'), category = _('HUD Control')},
	{down = hud_commands.AltitudeSelector,				cockpit_device_id = devices.HUDCONTROL, value_down = 0, name = _('HUD Altitude Selector BARO'), category = _('HUD Control')},
	{down = hud_commands.AltitudeSelector,				cockpit_device_id = devices.HUDCONTROL, value_down = 1, name = _('HUD Altitude Selector RDR'), category = _('HUD Control')}, 
	
	-- VSTOL Controls
	{down = iCommandPlane_ABRIS_Axis_Increase,			name = _('Flaps Mode Up (STOL - AUTO - CRUISE)'),	category = _('VSTOL Controls')},
	{down = iCommandPlane_ABRIS_Axis_Decrease,			name = _('Flaps Mode Down (CRUISE - AUTO - STOL)'),	category = _('VSTOL Controls')},
	{down = iCommandPlaneFlapsOn, 						name = _('Flaps Power Left (OFF - ON - RESET)'),	category = _('VSTOL Controls')},
	{down = iCommandPlaneFlapsOff,						name = _('Flaps Power Right (RESET - ON - OFF)'),	category = _('VSTOL Controls')},
	{down = iCommandPlane_ABRIS_Brightness_Increase,	name = _('Water Mode Up (LDG - OFF - TO)'),			category = _('VSTOL Controls')},
	{down = iCommandPlane_ABRIS_Brightness_Decrease,	name = _('Water Mode Down (TO - OFF - LDG)'),		category = _('VSTOL Controls')},
	{down = fcs_commands.Switch_FLAP_PWR,				cockpit_device_id = devices.VREST, value_down = 0.5, name = _('Flaps Power ON'), category = _('VSTOL Controls')},
	{down = fcs_commands.Switch_FLAP_PWR,				cockpit_device_id = devices.VREST, value_down = 0.0, name = _('Flaps Power OFF'), category = _('VSTOL Controls')},
	{down = fcs_commands.Switch_FLAP_PWR,				cockpit_device_id = devices.VREST, value_down = 1.0, name = _('Flaps Power RESET'), category = _('VSTOL Controls')},
	{down = fcs_commands.Switch_FLAP_PWR_ON_TOGGLE,		cockpit_device_id = devices.VREST, value_down = 0.0, name = _('Flaps Power ON/OFF'), category = _('VSTOL Controls')},
	{down = fcs_commands.Switch_FLAP_PWR_RESET_TOGGLE,	cockpit_device_id = devices.VREST, value_down = 1.0, name = _('Flaps Power RESET/OFF'), category = _('VSTOL Controls')},
	{down = fcs_commands.Switch_FLAP_SELECT,			cockpit_device_id = devices.VREST, value_down = 0.0, name = _('Flaps STOL'), category = _('VSTOL Controls')},
	{down = fcs_commands.Switch_FLAP_SELECT,			cockpit_device_id = devices.VREST, value_down = 0.5, name = _('Flaps AUTO, '), category = _('VSTOL Controls')},
	{down = fcs_commands.Switch_FLAP_SELECT,			cockpit_device_id = devices.VREST, value_down = 1.0, name = _('Flaps CRUISE, '), category = _('VSTOL Controls')},
  
	
	-- Flight Control
	{pressed = iCommandPlaneUpStart,						up = iCommandPlaneUpStop,			name = _('Aircraft Pitch DOWN'),	category = _('Flight Control')},
	{pressed = iCommandPlaneDownStart,						up = iCommandPlaneDownStop,			name = _('Aircraft Pitch UP'),		category = _('Flight Control')},
	{pressed = iCommandPlaneLeftStart,						up = iCommandPlaneLeftStop,			name = _('Aircraft Bank LEFT'),		category = _('Flight Control')},
	{pressed = iCommandPlaneRightStart,						up = iCommandPlaneRightStop,		name = _('Aircraft Bank RIGHT'),	category = _('Flight Control')},
	{pressed = iCommandPlaneLeftRudderStart,				up = iCommandPlaneLeftRudderStop,	name = _('Aircraft Rudder LEFT'),	category = _('Flight Control')},
	{pressed = iCommandPlaneRightRudderStart,				up = iCommandPlaneRightRudderStop,	name = _('Aircraft Rudder RIGHT'),	category = _('Flight Control')},
	{pressed = iCommandThrottleIncrease,					up = iCommandThrottleStop,			name = _('Throttle UP'),			category = _('Flight Control')},
	{pressed = iCommandThrottleDecrease,					up = iCommandThrottleStop,			name = _('Throttle DOWN'),			category = _('Flight Control')},
	{pressed = iCommandPlaneCollectiveIncrease,				up = iCommandPlaneCollectiveStop,	name = _('Nozzle Rotation UP'),		category = _('Flight Control')},
	{pressed = iCommandPlaneCollectiveDecrease,				up = iCommandPlaneCollectiveStop,	name = _('Nozzle Rotation DOWN'),	category = _('Flight Control')},
	{down = iCommandHelicopter_CollectiveStopper_Up,		up = iCommandPlaneCollectiveStop,	name = _('STO STOP UP'),			category = _('Flight Control')},
	{down = iCommandHelicopter_CollectiveStopper_Down,	    up = iCommandPlaneCollectiveStop,	name = _('STO STOP DOWN'),			category = _('Flight Control')},
	{pressed = iCommandPlaneTrimLeftRudder,					up = iCommandPlaneTrimStop,			name = _('Trim RUDDER LEFT'),		category = _('Flight Control')},
	{pressed = iCommandPlaneTrimRightRudder,				up = iCommandPlaneTrimStop,			name = _('Trim RUDDER RIGHT'),		category = _('Flight Control')},
	{down = iCommandADI_Test,																	name = _('Backup ADI Cage Toggle'),			category = _('Flight Control')},	
	{pressed = iCommandADI_ZeroPitchTrimLeft,				up = iCommandADI_Test_up,			name = _('Backup ADI Pitch Adjust Up'),		category = _('Flight Control')},	
	{pressed = iCommandADI_ZeroPitchTrimRight,				up = iCommandADI_Test_up,			name = _('Backup ADI Pitch Adjust Down'),	category = _('Flight Control')},	
	
	-- SAAHS
	{down = iCommandPlaneAutopilot,						name = _('Automatic Flight Control On/Off Toggle'),				category = _('Stability Augmentation & Autopilot')},
	{down = iCommandPlaneSAUHBarometric,				name = _('Altitude Hold On/Off Toggle'),						category = _('Stability Augmentation & Autopilot')},
	{down = iCommandPlaneAUTOnOff,						name = _('Q Feel On/Off Toggle'),								category = _('Stability Augmentation & Autopilot')},
	{down = iCommandPlaneSAUHRadio,						name = _('Stability Augmentation - Pitch'),						category = _('Stability Augmentation & Autopilot')},
	{down = iCommandPlaneSAUAutomatic,					name = _('Stability Augmentation - Yaw'),						category = _('Stability Augmentation & Autopilot')},
	{down = iCommandPlaneSAUHorizon,  					name = _('Stability Augmentation - Roll'),      															category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_RPS_YAW,				cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.0, name = _('RPS/YAW Shaker Switch OFF'),		category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_RPS_YAW,				cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.5, name = _('RPS/YAW Shaker Switch ON'),			category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_RPS_YAW,				cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1.0, name = _('RPS/YAW Shaker Switch TEST'),		category = _('Stability Augmentation & Autopilot')},    
    {down = fcs_commands.Switch_RPS_YAW_ON,				cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.0, name = _('RPS/YAW Shaker Switch OFF/ON'),  	category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_RPS_YAW_TEST,			cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.0, name = _('RPS/YAW Shaker Switch OFF/TEST'),	category = _('Stability Augmentation & Autopilot')},
    
    {down = fcs_commands.Switch_Q_FEEL,		cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1.0, name = _('Q Feel ON'), 							category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_Q_FEEL,		cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.0, name = _('Q Feel OFF'), 							category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_ALT_HOLD,	cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1.0, name = _('Altitude Hold ON'), 					category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_ALT_HOLD,	cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.0, name = _('Altitude Hold OFF'), 					category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_AFC,		cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1.0, name = _('Automatic Flight Control ON'), 			category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_AFC,		cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.5, name = _('Automatic Flight Control OFF'), 		category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_AFC,    	cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.0, name = _('Automatic Flight Control Reset'), 		category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_SAS_PITCH,	cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1.0, name = _('Stability Augmentation - Pitch ON'), 	category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_SAS_PITCH,	cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.0, name = _('Stability Augmentation - Pitch OFF'), 	category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_SAS_YAW,	cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1.0, name = _('Stability Augmentation - Yaw ON'), 		category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_SAS_YAW,	cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.0, name = _('Stability Augmentation - Yaw OFF'), 	category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_SAS_ROLL,	cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1.0, name = _('Stability Augmentation - Roll ON'), 	category = _('Stability Augmentation & Autopilot')},
    {down = fcs_commands.Switch_SAS_ROLL,	cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.0, name = _('Stability Augmentation - Roll OFF'), 	category = _('Stability Augmentation & Autopilot')},      
		
	-- Hydraulic & Mechanical
    {down = iCommandPlaneWheelBrakeOn,      up = iCommandPlaneWheelBrakeOff,      name = _('Wheel Brakes'),      category = _('Hydraulic & Mechanical')},
    {down = iCommandPlaneWheelBrakeLeftOn,  up = iCommandPlaneWheelBrakeLeftOff,  name = _('Wheel Brake LEFT'),  category = _('Hydraulic & Mechanical')},
    {down = iCommandPlaneWheelBrakeRightOn, up = iCommandPlaneWheelBrakeRightOff, name = _('Wheel Brake RIGHT'), category = _('Hydraulic & Mechanical')},
    {down = iCommandPlaneGear,     name = _('Landing Gear TOGGLE'), category = _('Hydraulic & Mechanical')},
    {down = iCommandPlaneGearUp,   name = _('Landing Gear UP'),     category = _('Hydraulic & Mechanical')},
    {down = iCommandPlaneGearDown, name = _('Landing Gear DOWN'),   category = _('Hydraulic & Mechanical')},
    {down = iCommandPlaneFonar,    name = _('Canopy Open/Close'),   category = _('Hydraulic & Mechanical')},
    {down = fcs_commands.Button_GEAR_DN_LOCK,  up = fcs_commands.Button_GEAR_DN_LOCK, cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1, value_up = 0, name = _('DN LOCK OVRD Landing Gear Button'),	category = _('Hydraulic & Mechanical')},
    {down = fcs_commands.Handle_GEAR_LEVER_EMERG,	cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1, name = _('Emergency Landing Gear Deployment'),	category = _('Hydraulic & Mechanical')},
    {down = fcs_commands.Handle_GEAR_BATT_LIFT,		cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1, name = _('Emergency Landing Gear Battery Activate'),	category = _('Hydraulic & Mechanical')},
	{down = fcs_commands.Handle_PARKING_BRAKE,		cockpit_device_id = devices.FLIGHTCONTROLS,	value_down= 0,	name = _('Parking Brake ON'),	category = _('Hydraulic & Mechanical')},
    {down = fcs_commands.Handle_PARKING_BRAKE,		cockpit_device_id = devices.FLIGHTCONTROLS,	value_down= 1,	name = _('Parking Brake OFF'),	category = _('Hydraulic & Mechanical')},
	{down = fcs_commands.Switch_ANTISKID,			cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 1, name = _('Anti-skid TEST'), category = _('Hydraulic & Mechanical')},
	{down = fcs_commands.Switch_ANTISKID,			cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0, name = _('Anti-skid NWS'), category = _('Hydraulic & Mechanical')},
	{down = fcs_commands.Switch_ANTISKID,			cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0.5, name = _('Anti-skid ON'), category = _('Hydraulic & Mechanical')},
	{down = fcs_commands.Switch_ANTISKID_NWS_TOGGLE,cockpit_device_id = devices.FLIGHTCONTROLS, value_down = 0, name = _('Anti-skid NWS/ON Toggle'), category = _('Hydraulic & Mechanical')},
	
	-- Engine & Fuel
	{down = iCommandPlaneHook,  			        name = _('Air Refueling Probe Toggle IN/OUT'),		category = _('Engine & Fuel')},
	{down = iCommandThrottle1Stop,			        name = _('Fuel Shutoff Lever lock release'),		category = _('Engine & Fuel')},
    {down = engine_commands.Switch_LIDS,	        cockpit_device_id = devices.VREST, value_down = 0, name = _('LIDS Switch NORM'),		        category = _('Engine & Fuel')},
    {down = engine_commands.Switch_LIDS,	        cockpit_device_id = devices.VREST, value_down = 1, name = _('LIDS Switch RETRACT'),		        category = _('Engine & Fuel')},
    {down = engine_commands.Switch_LIDS_TOGGLE,     cockpit_device_id = devices.VREST, value_down = 1, name = _('LIDS Switch TOGGLE'),           category = _('Engine & Fuel')},
    {down = engine_commands.Switch_ENG_RPM,	        cockpit_device_id = devices.DECS, value_down = 0, name = _('ENG RPM Switch LOW'),		        category = _('Engine & Fuel')},
    {down = engine_commands.Switch_ENG_RPM,	        cockpit_device_id = devices.DECS, value_down = 1, name = _('ENG RPM Switch HI'),		        category = _('Engine & Fuel')},
    {down = engine_commands.Switch_EFC,	            cockpit_device_id = devices.DECS, value_down = 0, name = _('EFC Switch POS 2'),		            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_EFC,	            cockpit_device_id = devices.DECS, value_down = 1, name = _('EFC Switch POS 1'),		            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_EFC_TOGGLE,      cockpit_device_id = devices.DECS, value_down = 1, name = _('EFC On/Off TOGGLE'),            category = _('Engine & Fuel')},     
    {down = engine_commands.Switch_H20,	            cockpit_device_id = devices.DECS, value_down = 0.5, name = _('H2O Switch OFF'),		            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_H20,	            cockpit_device_id = devices.DECS, value_down = 0, name = _('H2O Switch LDG'),		            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_H20,	            cockpit_device_id = devices.DECS, value_down = 1, name = _('H2O Switch TO'),		            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_H20_DUMP,	    cockpit_device_id = devices.DECS, value_down = 0, name = _('H2O Dump Switch OFF'),	            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_H20_DUMP,	    cockpit_device_id = devices.DECS, value_down = 1, name = _('H2O Dump Switch DUMP'),	            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_H20_DUMP_TOGGLE, cockpit_device_id = devices.DECS, value_down = 0, name = _('H2O Dump Switch TOGGLE'),         category = _('Engine & Fuel')},
    {down = engine_commands.Button_CMBT, up = engine_commands.Button_CMBT, cockpit_device_id = devices.DECS, value_down = 1, value_up = 0, name = _('CMBT Button PRESS'),	category = _('Engine & Fuel')},
    {down = engine_commands.Switch_JPTL,	        cockpit_device_id = devices.DECS, value_down = 0, name = _('JPTL Switch ON'),		            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_JPTL,	        cockpit_device_id = devices.DECS, value_down = 1, name = _('JPTL Switch OFF'),		            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_JPTLTOGGLE,    	cockpit_device_id = devices.DECS, value_down = 0, name = _('JPTL Switch TOGGLE'),               category = _('Engine & Fuel')},
    {down = engine_commands.Button_EMS, up = engine_commands.Button_EMS, cockpit_device_id = devices.DECS, value_down = 1, value_up = 0, name = _('EMS Button PRESS'),	category = _('Engine & Fuel')},
    {down = engine_commands.Switch_MAN_FUEL,	    cockpit_device_id = devices.DECS, value_down = 0, name = _('Manual Fuel Switch OFF'),		            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_MAN_FUEL,	    cockpit_device_id = devices.DECS, value_down = 1, name = _('Manual Fuel Switch ON'),		            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_MAN_FUEL_TOGGLE, cockpit_device_id = devices.DECS, value_down = 0, name = _('Manual Fuel Switch TOGGLE'),          category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PROP,	    cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel PROP Switch OFF'),		        category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PROP,	    cockpit_device_id = devices.DECS, value_down = 1, name = _('Fuel PROP Switch ON'),		        category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PROP_TOGGLE, cockpit_device_id = devices.DECS, value_down = 0, value_up = 1, name = _('Fuel PROP Switch TOGGLE'),    category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PUMP_L,	    cockpit_device_id = devices.DECS, value_down = 0.5, name = _('Fuel Pump Left Switch OFF'),		category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PUMP_L,	    cockpit_device_id = devices.DECS, value_down = 1, name = _('Fuel Pump Left Switch ON'),		    category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PUMP_L,	    cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Pump Left Switch DC OPR'),		category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PUMP_L_TOGGLE_ON, cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Pump Left Switch ON/OFF'),       category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PUMP_L_TOGGLE_OPR,cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Pump Left Switch DC OPR/OFF'),   category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PUMP_R,	    cockpit_device_id = devices.DECS, value_down = 0.5, name = _('Fuel Pump Right Switch OFF'),		category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PUMP_R,	    cockpit_device_id = devices.DECS, value_down = 1, name = _('Fuel Pump Right Switch ON'),		category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PUMP_R,	    cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Pump Right Switch DC OPR'),	category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PUMP_R_TOGGLE_ON, cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Pump Right Switch ON/OFF'),    category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PUMP_R_TOGGLE_OPR,cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Pump Right Switch DC OPR/OFF'),    category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PRESS,	    cockpit_device_id = devices.DECS, value_down = 0, name = _('Air Refueling Probe Switch IN'),	category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PRESS,	    cockpit_device_id = devices.DECS, value_down = 0.5, name = _('Air Refueling Probe Switch OUT'),	category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PRESS,	    cockpit_device_id = devices.DECS, value_down = 1, name = _('Air Refueling Probe Switch PRESS'),	category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_PRESS_TOGGLE, cockpit_device_id = devices.DECS, value_down = 0, name = _('Air Refueling Probe Toggle IN/PRESS'), category = _('Engine & Fuel')},         
    {down = engine_commands.Switch_FUEL_DUMP_L,	    cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Dump Left Switch NORM'),		category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_DUMP_L,	    cockpit_device_id = devices.DECS, value_down = 1, name = _('Fuel Dump Left Switch DUMP'),		category = _('Engine & Fuel')},         
    {down = engine_commands.Switch_FUEL_DUMP_L_TOGGLE, cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Dump Left Switch TOGGLE'),   category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_DUMP_R,	    cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Dump Right Switch NORM'),		category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_DUMP_R,	    cockpit_device_id = devices.DECS, value_down = 1, name = _('Fuel Dump Right Switch DUMP'),		category = _('Engine & Fuel')},
    {down = engine_commands.Switch_FUEL_DUMP_R_TOGGLE, cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Dump Right Switch TOGGLE'),    category = _('Engine & Fuel')},
    {down = engine_commands.Handle_FUEL_SHUT_OFF,	cockpit_device_id = devices.DECS, value_down = 0, name = _('Fuel Shutoff Lever OFF'),		    category = _('Engine & Fuel')},
    {down = engine_commands.Handle_FUEL_SHUT_OFF,	cockpit_device_id = devices.DECS, value_down = 1, name = _('Fuel Shutoff Lever ON'),		    category = _('Engine & Fuel')},
    {down = engine_commands.Switch_DECS,	        cockpit_device_id = devices.DECS, value_down = 0, name = _('DECS Switch OFF'),		            category = _('Engine & Fuel')},      
    {down = engine_commands.Switch_DECS,	        cockpit_device_id = devices.DECS, value_down = 1, name = _('DECS Switch ON'),		            category = _('Engine & Fuel')},
    {down = engine_commands.Switch_DECS_TOGGLE,  	cockpit_device_id = devices.DECS, value_down = 0,   name = _('DECS On/Off TOGGLE'),          category = _('Engine & Fuel')},      
	
    -- ECS
    {down = psp_commands.Switch_OXY,        		cockpit_device_id = devices.ECS, value_down = 0,    name = _('Oxygen Switch OFF'),      category = _('Environmental Control')},     
    {down = psp_commands.Switch_OXY,        		cockpit_device_id = devices.ECS, value_down = 1,    name = _('Oxygen Switch ON'),     category = _('Environmental Control')},
    {down = psp_commands.Switch_OXY_TOGGLE, 		cockpit_device_id = devices.ECS, value_down = 0, name = _('Oxygen Switch TOGGLE'),     category = _('Environmental Control')},  	
     
	-- Electrical Panel
	{down = elec_commands.Switch_BATT, 				cockpit_device_id = devices.ELECTRIC, value_down = 1,	name = _('Battery ON'),					category = _('Electrical Panel')},
	{down = elec_commands.Switch_BATT, 				cockpit_device_id = devices.ELECTRIC, value_down = 0.5,	name = _('Battery OFF'),				category = _('Electrical Panel')},
	{down = elec_commands.Switch_BATT, 				cockpit_device_id = devices.ELECTRIC, value_down = 0,	name = _('Battery Alert'),				category = _('Electrical Panel')},
	{down = elec_commands.Switch_BATT_ON_TOGGLE, 	cockpit_device_id = devices.ELECTRIC, value_down = 0, name = _('Battery ON/OFF'),        category = _('Electrical Panel')},
	{down = elec_commands.Switch_GEN, 				cockpit_device_id = devices.ELECTRIC, value_down = 1,	name = _('Generator ON'),				category = _('Electrical Panel')},
	{down = elec_commands.Switch_GEN, 				cockpit_device_id = devices.ELECTRIC, value_down = 0.5,	name = _('Generator OFF'),				category = _('Electrical Panel')},
	{down = elec_commands.Switch_GEN, 				cockpit_device_id = devices.ELECTRIC, value_down = 0,	name = _('Generator Test'),				category = _('Electrical Panel')},
	{down = elec_commands.Switch_GEN_ON_TOGGLE, 	cockpit_device_id = devices.ELECTRIC, value_down = 0, name = _('Generator ON/OFF'),       category = _('Electrical Panel')},
	{down = elec_commands.Switch_ENG_START, 		cockpit_device_id = devices.ELECTRIC, value_down = 1,	name = _('Engine Start ON'),			category = _('Electrical Panel')},
	{down = elec_commands.Switch_ENG_START, 		cockpit_device_id = devices.ELECTRIC, value_down = 0,	name = _('Engine Start OFF'),			category = _('Electrical Panel')},
	{down = elec_commands.Switch_APU_GEN, 			cockpit_device_id = devices.ELECTRIC, value_down = 1,	name = _('APU Generator Switch RESET'),	category = _('Electrical Panel')},
	{down = elec_commands.Switch_APU_GEN, 			cockpit_device_id = devices.ELECTRIC, value_down = 0.5,	name = _('APU Generator Switch ON'),	category = _('Electrical Panel')},
	{down = elec_commands.Switch_APU_GEN, 			cockpit_device_id = devices.ELECTRIC, value_down = 0,	name = _('APU Generator Switch OFF'),	category = _('Electrical Panel')},
	
	-- Pilot & Seat Controls 
	{down = iCommandToggleMirrors,					name = _('Mirrors TOGGLE'),				category = _('Pilot & Seat Controls')},
    {down = iCommandPlaneEject,						name = _('Eject (3 times)'),			category = _('Pilot & Seat Controls')},	
	{down = iCommandCockpitShowPilotOnOff,  		name = _('Hide/Show Pilot Body'),		category = _('Pilot & Seat Controls')},
	{down = iCommandPlaneCircuitBreaker_10, 		name = _('Hide/Show Stick and Throttle'),	category = _('Pilot & Seat Controls')},	
	{down = iCommandViewNightVisionGogglesOn,		name = _('Helmet Visor/NVG Toggle'),	category = _('Pilot & Seat Controls')},
	{															down = iCommandPlaneModeFI0,				name = _('Switch the Helmet Visor for NVG and viceversa'),	category = _('Pilot & Seat Controls')},
	{															down = iCommandPlane_Helmet_Brightess_Up,	name = _('NVG Brightness Up'),			category = _('Pilot & Seat Controls')},
	{															down = iCommandPlane_Helmet_Brightess_Down,	name = _('NVG Brightness Down'),		category = _('Pilot & Seat Controls')},
	{down =  msc_commands.Seat_SFTY_LVR_TOGGLE, cockpit_device_id = devices.MSC, value_down = 0, name = _("Seat Ground Safety Lever"),  category = _('Pilot & Seat Controls')},
	{down =  msc_commands.Seat_SFTY_LVR, cockpit_device_id = devices.MSC, value_down = 0, name = _("Seat Ground Safety Lever Up"),  category = _('Pilot & Seat Controls')},
	{down =  msc_commands.Seat_SFTY_LVR, cockpit_device_id = devices.MSC, value_down = 1, name = _("Seat Ground Safety Lever Down"),  category = _('Pilot & Seat Controls')},
	
	-- HOTAS
	-- Stick
	{down = iCommandPlaneFire,         up = iCommandPlaneFireOff,   name = _('Trigger: Fire Gun/Launch Sidewinder, Sidearm'),     		category = _('HOTAS')},
	{down = iCommandPlanePickleOn,     up = iCommandPlanePickleOff, name = _('Bomb Pickle: Release Bombs/Launch Rockets, Mavericks'),	category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_BoatSwitchForward,                  name = _('A/A Mode FWD: Sidewinder (Boresight)'),					category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_BoatSwitchAft,                      name = _('A/A Mode AFT: Sidewinder (SEAM)'),						category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_BoatSwitchCenter,                   name = _('A/A Mode DOWN: Gun'),										category = _('HOTAS')},
	
	{pressed = iCommandPlaneTrimUp,    up = iCommandPlaneTrimStop,  name = _('Trim Pitch DOWN'),						category = _('HOTAS')},
	{pressed = iCommandPlaneTrimDown,  up = iCommandPlaneTrimStop,  name = _('Trim Pitch UP'),							category = _('HOTAS')},
	{pressed = iCommandPlaneTrimLeft,  up = iCommandPlaneTrimStop,  name = _('Trim Bank LEFT'),							category = _('HOTAS')},
	{pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop,  name = _('Trim Bank RIGHT'),						category = _('HOTAS')},
	
	{down = iCommandPlane_HOTAS_PinkySwitchForward,			up = iCommandPlane_HOTAS_PinkySwitchCenter,			name = _('WP Increment'),								category = _('HOTAS')},
	{down = iCommandPlaneAutopilotOverrideOn,				up = iCommandPlaneAutopilotOverrideOff,				name = _('Emergency SAAHS Disconnect'),					category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_DataManagementSwitchUp,		up = iCommandPlane_HOTAS_DataManagementSwitchOff,	name = _('Sensor Select FWD: INS, IRMV/EOMV'),  		category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_DataManagementSwitchDown,	up = iCommandPlane_HOTAS_DataManagementSwitchOff,	name = _('Sensor Select AFT: DMT: LST/TV'),  			category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_DataManagementSwitchLeft,	up = iCommandPlane_HOTAS_DataManagementSwitchOff,	name = _('Sensor Select LEFT: MAP Center/Decenter'),	category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_DataManagementSwitchRight,	up = iCommandPlane_HOTAS_DataManagementSwitchOff,	name = _('Sensor Select RIGHT: FLIR BH/WH'),			category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_ChinaHatForward,			up = iCommandPlane_HOTAS_DataManagementSwitchOff,	name = _('Sensor Select DOWN: HUD Scene Reject/TGP'),	category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_NoseWheelSteeringButton,	up = iCommandPlane_HOTAS_NoseWheelSteeringButtonOff,name = _('AG Target Undesignate / NWS / FOV Toggle'),	category = _('HOTAS')},
	
	-- Throttle
	{down = iCommandPlaneDropChaffOnce,						name = _('ECM Dispense AFT: Chaff'),		category = _('HOTAS')},
	{down = iCommandPlaneDropFlareOnce,						name = _('ECM Dispense FWD: Flares'),		category = _('HOTAS')},
	{down = iCommandPlaneCMDDispenceOff,					name = _('ECM Dispense RIGHT: All'),		category = _('HOTAS')},
	{down = iCommandPlaneCMDDispence,						name = _('ECM Dispense LEFT: Mini Jammer'),	category = _('HOTAS')},
	
	{down = iCommandPlane_ABRIS_Axis_Push,					name = _('Cage/Uncage'),					category = _('HOTAS')},
	
	{down = iCommandPlane_HOTAS_CMS_Up,	up = iCommandPlane_HOTAS_CMS_Left,  name = _('Engine Air Start'),				category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_CMS_Down, up = iCommandPlane_HOTAS_CMS_Off, name = _('Emergency Flap Retraction'),		category = _('HOTAS')},
	
	{down = iCommandPlane_HOTAS_MIC_SwitchUp,				name = _('COMM FWD: Select COMM 1'),		category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_MIC_SwitchDown,				name = _('COMM AFT: Select COMM 2'),		category = _('HOTAS')},
	-- Missing COMM CENTER
	
	{down = iCommandPlaneAirBrake,							                        name = _('Airbrake TOGGLE'),		category = _('HOTAS')},
	{pressed = iCommandPlaneAirBrakeOn, up = iCommandHelicopter_PPR_button_K_up,	name = _('Airbrake OUT'),			category = _('HOTAS')},
	{pressed = iCommandPlaneAirBrakeOff, up = iCommandHelicopter_PPR_button_K_up,	name = _('Airbrake IN'),			category = _('HOTAS')},
	{pressed = iCommandPlaneAirBrakeOff, up = iCommandPlaneAirBrakeOn,	name = _('Airbrake 2POS'),			category = _('HOTAS')},

	
	{pressed = iCommandPlane_HOTAS_CoolieUp,				up = iCommandPlane_HOTAS_CoolieOff, 		name = _('TDC Forward'),					category = _('HOTAS')},
	{pressed = iCommandPlane_HOTAS_CoolieDown,  			up = iCommandPlane_HOTAS_CoolieOff, 		name = _('TDC Aft'),						category = _('HOTAS')},
	{pressed = iCommandPlane_HOTAS_CoolieLeft,  			up = iCommandPlane_HOTAS_CoolieOff, 		name = _('TDC Left'),						category = _('HOTAS')},
	{pressed = iCommandPlane_HOTAS_CoolieRight, 			up = iCommandPlane_HOTAS_CoolieOff, 		name = _('TDC Right'),						category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_TDC_depress_on,				up = iCommandPlane_HOTAS_TDC_depress_off,	name = _('TDC Down (Action Position)'),		category = _('HOTAS')},
	{down = iCommandPlane_HOTAS_TriggerSecondStage_Off,													name = _('TDC Action/No Action Toggle'),	category = _('HOTAS')},
	
	{down = engine_commands.Handle_THROTTLE_CUTOFF,			up = engine_commands.Handle_THROTTLE_CUTOFF,
	 cockpit_device_id = devices.DECS, value_down = 1, value_up = 0, name = _('Throttle Cutoff'),     category = _('HOTAS')},
	
	-- Left MPCD
	{down = iCommandPlaneLeftMFD_OSB1 , up = iCommandPlaneLeftMFD_OSB1_Off,  name = _('Left MPCD OSB 01'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB2 , up = iCommandPlaneLeftMFD_OSB2_Off,  name = _('Left MPCD OSB 02'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB3 , up = iCommandPlaneLeftMFD_OSB3_Off,  name = _('Left MPCD OSB 03'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB4 , up = iCommandPlaneLeftMFD_OSB4_Off,  name = _('Left MPCD OSB 04'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB5 , up = iCommandPlaneLeftMFD_OSB5_Off,  name = _('Left MPCD OSB 05'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB6 , up = iCommandPlaneLeftMFD_OSB6_Off,  name = _('Left MPCD OSB 06'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB7 , up = iCommandPlaneLeftMFD_OSB7_Off,  name = _('Left MPCD OSB 07'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB8 , up = iCommandPlaneLeftMFD_OSB8_Off,  name = _('Left MPCD OSB 08'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB9 , up = iCommandPlaneLeftMFD_OSB9_Off,  name = _('Left MPCD OSB 09'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB10, up = iCommandPlaneLeftMFD_OSB10_Off, name = _('Left MPCD OSB 10'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB11, up = iCommandPlaneLeftMFD_OSB11_Off, name = _('Left MPCD OSB 11'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB12, up = iCommandPlaneLeftMFD_OSB12_Off, name = _('Left MPCD OSB 12'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB13, up = iCommandPlaneLeftMFD_OSB13_Off, name = _('Left MPCD OSB 13'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB14, up = iCommandPlaneLeftMFD_OSB14_Off, name = _('Left MPCD OSB 14'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB15, up = iCommandPlaneLeftMFD_OSB15_Off, name = _('Left MPCD OSB 15'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB16, up = iCommandPlaneLeftMFD_OSB16_Off, name = _('Left MPCD OSB 16'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB17, up = iCommandPlaneLeftMFD_OSB17_Off, name = _('Left MPCD OSB 17'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB18, up = iCommandPlaneLeftMFD_OSB18_Off, name = _('Left MPCD OSB 18'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB19, up = iCommandPlaneLeftMFD_OSB19_Off, name = _('Left MPCD OSB 19'), category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_OSB20, up = iCommandPlaneLeftMFD_OSB20_Off, name = _('Left MPCD OSB 20'), category = _('Left MPCD')},
	
	{pressed = iCommandPlaneLeftMFD_SYM_Up,			up = iCommandPlaneLeftMFD_SYM_Stop,		name = _('Left MPCD SYM Increase'),		category = _('Left MPCD')},
	{pressed = iCommandPlaneLeftMFD_SYM_Dn,			up = iCommandPlaneLeftMFD_SYM_Stop,		name = _('Left MPCD SYM Decrease'),		category = _('Left MPCD')},
	{pressed = iCommandPlaneLeftMFD_CON_Increase,	up = iCommandPlaneLeftMFD_CON_Stop,		name = _('Left MPCD CON Increase'),		category = _('Left MPCD')},
	{pressed = iCommandPlaneLeftMFD_CON_Decrease,	up = iCommandPlaneLeftMFD_CON_Stop,		name = _('Left MPCD CON Decrease'),		category = _('Left MPCD')},
	{pressed = iCommandPlaneLeftMFD_BRT_Increase,	up = iCommandPlaneLeftMFD_BRT_Stop,		name = _('Left MPCD BRT Increase'),		category = _('Left MPCD')},
	{pressed = iCommandPlaneLeftMFD_BRT_Decrease,	up = iCommandPlaneLeftMFD_BRT_Stop,		name = _('Left MPCD BRT Decrease'),		category = _('Left MPCD')},
	{pressed = iCommandPlaneLeftMFD_DSP_Increase,	up = iCommandPlaneLeftMFD_DSP_Stop,		name = _('Left MPCD GAIN Increase'),	category = _('Left MPCD')},
	{pressed = iCommandPlaneLeftMFD_DSP_Decrease,	up = iCommandPlaneLeftMFD_DSP_Stop,		name = _('Left MPCD GAIN Decrease'),	category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_BRTMODE_NIGHT,		up = iCommandPlaneLeftMFD_BRTMODE_OFF,	name = _('Left MPCD Night Mode'),		category = _('Left MPCD')},
	{down = iCommandPlaneLeftMFD_BRTMODE_DAY,		up = iCommandPlaneLeftMFD_BRTMODE_OFF,	name = _('Left MPCD Day Mode'),			category = _('Left MPCD')},
	
	{down = iCommand_UV26_PowerCover,													name = _('Left MPCD Export View ON/OFF'),	category = _('Left MPCD')},
	
	-- Right MPCD
	{down = iCommandPlaneRightMFD_OSB1 , up = iCommandPlaneRightMFD_OSB1_Off,  name = _('Right MPCD OSB 01'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB2 , up = iCommandPlaneRightMFD_OSB2_Off,  name = _('Right MPCD OSB 02'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB3 , up = iCommandPlaneRightMFD_OSB3_Off,  name = _('Right MPCD OSB 03'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB4 , up = iCommandPlaneRightMFD_OSB4_Off,  name = _('Right MPCD OSB 04'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB5 , up = iCommandPlaneRightMFD_OSB5_Off,  name = _('Right MPCD OSB 05'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB6 , up = iCommandPlaneRightMFD_OSB6_Off,  name = _('Right MPCD OSB 06'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB7 , up = iCommandPlaneRightMFD_OSB7_Off,  name = _('Right MPCD OSB 07'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB8 , up = iCommandPlaneRightMFD_OSB8_Off,  name = _('Right MPCD OSB 08'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB9 , up = iCommandPlaneRightMFD_OSB9_Off,  name = _('Right MPCD OSB 09'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB10, up = iCommandPlaneRightMFD_OSB10_Off, name = _('Right MPCD OSB 10'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB11, up = iCommandPlaneRightMFD_OSB11_Off, name = _('Right MPCD OSB 11'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB12, up = iCommandPlaneRightMFD_OSB12_Off, name = _('Right MPCD OSB 12'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB13, up = iCommandPlaneRightMFD_OSB13_Off, name = _('Right MPCD OSB 13'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB14, up = iCommandPlaneRightMFD_OSB14_Off, name = _('Right MPCD OSB 14'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB15, up = iCommandPlaneRightMFD_OSB15_Off, name = _('Right MPCD OSB 15'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB16, up = iCommandPlaneRightMFD_OSB16_Off, name = _('Right MPCD OSB 16'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB17, up = iCommandPlaneRightMFD_OSB17_Off, name = _('Right MPCD OSB 17'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB18, up = iCommandPlaneRightMFD_OSB18_Off, name = _('Right MPCD OSB 18'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB19, up = iCommandPlaneRightMFD_OSB19_Off, name = _('Right MPCD OSB 19'), category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_OSB20, up = iCommandPlaneRightMFD_OSB20_Off, name = _('Right MPCD OSB 20'), category = _('Right MPCD')},
	
	{pressed = iCommandPlaneRightMFD_SYM_Up,		up = iCommandPlaneRightMFD_SYM_Stop,	name = _('Right MPCD SYM Increase'),	category = _('Right MPCD')},
	{pressed = iCommandPlaneRightMFD_SYM_Dn,		up = iCommandPlaneRightMFD_SYM_Stop,	name = _('Right MPCD SYM Decrease'),	category = _('Right MPCD')},
	{pressed = iCommandPlaneRightMFD_CON_Increase,	up = iCommandPlaneRightMFD_CON_Stop,	name = _('Right MPCD CON Increase'),	category = _('Right MPCD')},
	{pressed = iCommandPlaneRightMFD_CON_Decrease,	up = iCommandPlaneRightMFD_CON_Stop,	name = _('Right MPCD CON Decrease'),	category = _('Right MPCD')},
	{pressed = iCommandPlaneRightMFD_BRT_Increase,	up = iCommandPlaneRightMFD_BRT_Stop,	name = _('Right MPCD BRT Increase'),	category = _('Right MPCD')},
	{pressed = iCommandPlaneRightMFD_BRT_Decrease,	up = iCommandPlaneRightMFD_BRT_Stop,	name = _('Right MPCD BRT Decrease'),	category = _('Right MPCD')},
	{pressed = iCommandPlaneRightMFD_DSP_Increase,	up = iCommandPlaneRightMFD_DSP_Stop,	name = _('Right MPCD GAIN Increase'),	category = _('Right MPCD')},
	{pressed = iCommandPlaneRightMFD_DSP_Decrease,	up = iCommandPlaneRightMFD_DSP_Stop,	name = _('Right MPCD GAIN Decrease'),	category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_BRTMODE_NIGHT,	up = iCommandPlaneRightMFD_BRTMODE_OFF,	name = _('Right MPCD Night Mode'),		category = _('Right MPCD')},
	{down = iCommandPlaneRightMFD_BRTMODE_DAY,		up = iCommandPlaneRightMFD_BRTMODE_OFF,	name = _('Right MPCD Day Mode'),		category = _('Right MPCD')},
	
	{down = iCommand_UV26_BITCover,															name = _('Right MPCD Export View ON/OFF'),	category = _('Right MPCD')},
	
	-- ARMAMENT CONTROL PANEL
	{down = iCommandSwitchMasterArm,				name = _('Master Arm Switch Toggle'), 						category = _('Armament Control')},
	{pressed = iCommandPlaneCMDChangeBurstAmount,	name = _('Launch Flare Salvo'),						category = _('Armament Control')},
	
	{down = iCommandPlaneCDU_A,						name = _('Armament Mode Control Up'),				category = _('Armament Control')},
	{down = iCommandPlaneCDU_B,						name = _('Armament Mode Control Down'),				category = _('Armament Control')},
	{down = iCommandPlaneCDU_C,						name = _('Weapons Fuze Control Up'),				category = _('Armament Control')},
	{down = iCommandPlaneCDU_D,						name = _('Weapons Fuze Control Down'),				category = _('Armament Control')},
	{down = iCommandPlaneCDU_E,						name = _('Release Quantity (10s) Control Up'),		category = _('Armament Control')},
	{down = iCommandPlaneCDU_F,						name = _('Release Quantity (10s) Control Down'),	category = _('Armament Control')},
	{down = iCommandPlaneCDU_G,						name = _('Release Quantity (1s) Control Up'),		category = _('Armament Control')},
	{down = iCommandPlaneCDU_H,						name = _('Release Quantity (1s) Control Down'),		category = _('Armament Control')},
	{down = iCommandPlaneCDU_I,						name = _('Multiple Release Control Up'),			category = _('Armament Control')},
	{down = iCommandPlaneCDU_J,						name = _('Multiple Release Control Down'),			category = _('Armament Control')},
	{down = iCommandPlaneCDU_K,						name = _('Release Interval (100s) Control Up'),		category = _('Armament Control')},
	{down = iCommandPlaneCDU_L,						name = _('Release Interval (100s) Control Down'),	category = _('Armament Control')},
	{down = iCommandPlaneCDU_M,						name = _('Release Interval (10s) Control Up'),		category = _('Armament Control')},
	{down = iCommandPlaneCDU_N,						name = _('Release Interval (10s) Control Down'),	category = _('Armament Control')},
	{down = iCommandPlaneCDU_O,						name = _('Release Interval (1s) Control Up'),		category = _('Armament Control')},
	{down = iCommandPlaneCDU_P,						name = _('Release Interval (1s) Control Down'),		category = _('Armament Control')},
	{down = iCommandPlaneCDU_Q,						name = _('Manual Release Control Left'),			category = _('Armament Control')},
	{down = iCommandPlaneCDU_R,						name = _('Manual Release Control Right'),			category = _('Armament Control')},
	{down = iCommandPlaneCDU_S,						name = _('Selective Jettison Selector Left'),		category = _('Armament Control')},
	{down = iCommandPlaneCDU_T,						name = _('Selective Jettison Selector Right'),		category = _('Armament Control')},
	{down = iCommandPlaneJettisonWeapons,			name = _('Jettison Pushbutton'),					category = _('Armament Control')},
	{down = iCommandPlaneNav_PB1,					name = _('Station 1 Pushbutton'),					category = _('Armament Control')},
	{down = iCommandPlaneNav_PB2,					name = _('Station 2 Pushbutton'),					category = _('Armament Control')},
	{down = iCommandPlaneNav_PB3,					name = _('Station 3 Pushbutton'),					category = _('Armament Control')},
	{down = iCommandPlaneNav_PB4,					name = _('Station 4 Pushbutton'),					category = _('Armament Control')},
	{down = iCommandPlaneNav_PB5,					name = _('Station 5 Pushbutton'),					category = _('Armament Control')},
	{down = iCommandPlaneNav_PB6,					name = _('Station 6 Pushbutton'),					category = _('Armament Control')},
	{down = iCommandPlaneNav_PB7,					name = _('Station 7 Pushbutton'),					category = _('Armament Control')},
	{down = iCommandPlaneNav_PB8,					name = _('IR Cooling control'),						category = _('Armament Control')},
	
	{down = smc_commands.Switch_IR_COOL,		cockpit_device_id = devices.SMC, value_down = 1, name = _("Ground IR Cooling ON"), category = _('Armament Control')},
	{down = smc_commands.Switch_IR_COOL,		cockpit_device_id = devices.SMC, value_down = 0, name = _("Ground IR Cooling OFF"), category = _('Armament Control')},
	{down = smc_commands.Switch_IR_COOL_TOGGLE, cockpit_device_id = devices.SMC, value_down = 0, name = _("Ground IR Cooling Toggle"), category = _('Armament Control')},
	
	{down = iCommandPlaneJettisonFuelTanks,			name = _('Emergency Jettison Pushbutton'),			category = _('Armament Control')},
	{combos = {{key = 'T'}}, down = iCommandPlaneWingtipSmokeOnOff, name = _('Smoke'),                  category = _('Armament Control')}, 
	
	{down = smc_commands.Switch_Master_Arm, cockpit_device_id = devices.SMC, value_down = 1, name = _('Master Arm Switch ON'), category = _('Armament Control')},
	{down = smc_commands.Switch_Master_Arm, cockpit_device_id = devices.SMC, value_down = 0, name = _('Master Arm Switch OFF'), category = _('Armament Control')},
    
	-- UFC
	{down = iCommandPlaneUFC_1,						name = _('UFC 1 Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneUFC_2,						name = _('UFC 2/N Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneUFC_3,						name = _('UFC 3 Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneUFC_4,						name = _('UFC 4/W Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneUFC_5,						name = _('UFC 5 Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneUFC_6,						name = _('UFC 6/E Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneUFC_7,						name = _('UFC 7 Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneUFC_8,						name = _('UFC 8/S Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneUFC_9,						name = _('UFC 9 Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneUFC_0,						name = _('UFC 0 Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneCDU_PNT,					name = _('UFC . Button'),								category = _('Up Front Control')},
	{down = iCommandPlaneCDU_SLASH,					name = _('UFC - Button'),								category = _('Up Front Control')},
	
	{down = iCommandPlaneUFC_HACK,					name = _('UFC Timer Function Button'),					category = _('Up Front Control')},
	{down = iCommandPlaneUFC_STEER_UP,				name = _('UFC Target-Of-Opportunity Function Button'),	category = _('Up Front Control')},
	{down = iCommandPlaneUFC_CLR,					name = _('UFC Clear Button'),							category = _('Up Front Control')},
	{down = iCommandPlaneUFC_SPC,					name = _('UFC Save Button'),							category = _('Up Front Control')},
	{down = iCommandPlaneUFC_ENT,					name = _('UFC Enter Button'),							category = _('Up Front Control')},
	{down = iCommandPlaneUFC_SEL_UP,				name = _('UFC ON/OFF Toggle Button'),					category = _('Up Front Control')},
	{down = iCommandPlaneUFC_LTR,					name = _('UFC IFF Function Button'),					category = _('Up Front Control')},
	{down = iCommandPlaneUFC_DATA_UP,				name = _('UFC TACAN Function Button'),					category = _('Up Front Control')},
	{down = iCommandPlaneUFC_DATA_DOWN,				name = _('UFC AWLS Function Button'),					category = _('Up Front Control')},
	{down = iCommandPlaneUFC_FUNC,					name = _('UFC Weapons Function Button'),				category = _('Up Front Control')},
	{down = iCommandPlaneUFC_STEER_DOWN,			name = _('UFC Wpt Over Fly Function Button'),			category = _('Up Front Control')},
	{down = iCommandPlaneUFC_MK,					name = _('UFC RDR Beacon Function Button'),				category = _('Up Front Control')},
	{down = iCommandPlaneUFC_ALT,					name = _('UFC Altimeter Function Button'),				category = _('Up Front Control')},
	{down = iCommandPlaneUFC_SEL_DOWN,				name = _('UFC EMCON Toggle Button'),					category = _('Up Front Control')},
	{down = iCommandPlaneUFC_DEPR_DOWN, up = iCommandPlaneUFC_DEPR_UP,	name = _('UFC I/P Button'),			category = _('Up Front Control')},
	{pressed = iCommandPlaneUFC_INTEN_INCREASE, 	name = _('UFC Display Brightness Increase'),			category = _('Up Front Control')},
	{pressed = iCommandPlaneUFC_INTEN_DECREASE, 	name = _('UFC Display Brightness Decrease'),			category = _('Up Front Control')},
	
	-- ODU
	{down = iCommandPlaneCDU_1,						name = _('ODU Option 1'),								category = _('Up Front Control')},
	{down = iCommandPlaneCDU_2,						name = _('ODU Option 2'),								category = _('Up Front Control')},
	{down = iCommandPlaneCDU_3,						name = _('ODU Option 3'),								category = _('Up Front Control')},
	{down = iCommandPlaneCDU_4,						name = _('ODU Option 4'),								category = _('Up Front Control')},
	{down = iCommandPlaneCDU_5,						name = _('ODU Option 5'),								category = _('Up Front Control')},
	
	-- Communications
	{pressed = iCommandPlane_VHF_FM_Volume_Dec, 														name = _('UHF Radio 1 Volume Decrease'),				category = _('Radios Control')},
	{pressed = iCommandPlane_VHF_FM_Volume_Inc, 														name = _('UHF Radio 1 Volume Increase'),				category = _('Radios Control')},
	{down = iCommandPlane_VHF_FM_FreqMode_OFF,															name = _('UHF Radio 1 Selector'),						category = _('Radios Control')},
	{down = iCommandPlane_VHF_FM_Preset_Dec, 															name = _('UHF Radio 1 Preset Channel Decrease'),		category = _('Radios Control')},
	{down = iCommandPlane_VHF_FM_Preset_Inc, 															name = _('UHF Radio 1 Preset Channel Increase'),		category = _('Radios Control')},
	
	{pressed = iCommandPlane_VHF_AM_Volume_Dec, 														name = _('UHF Radio 2 Volume Decrease'),				category = _('Radios Control')},
	{pressed = iCommandPlane_VHF_AM_Volume_Inc, 														name = _('UHF Radio 2 Volume Increase'),				category = _('Radios Control')},
	{down = iCommandPlane_VHF_AM_FreqMode_OFF,															name = _('UHF Radio 2 Selector'),						category = _('Radios Control')},
	{down = iCommandPlane_VHF_AM_Preset_Dec, 															name = _('UHF Radio 2 Preset Channel Decrease'),		category = _('Radios Control')},
	{down = iCommandPlane_VHF_AM_Preset_Inc, 															name = _('UHF Radio 2 Preset Channel Increase'),		category = _('Radios Control')},
	
	{down = iCommandPlaneIntercomHM, 																	name = _('UHF Radio Control Selector (UFC/RCU-8150)'),	category = _('Radios Control')},
	{down = iCommandPlaneIntercomVHF, 																	name = _('UHF RCU-8150 Radio Selector (COM1/COM2)'),	category = _('Radios Control')},

	{down = iCommandPlaneUHFPresetChannelSelectorInc, 													name = _('UHF RCU-8150 Chan/Freq Knob CW'),				category = _('Radios Control')},
	{down = iCommandPlaneUHFPresetChannelSelectorDec, 													name = _('UHF RCU-8150 Chan/Freq Knob CCW'),			category = _('Radios Control')},
	{pressed = iCommandPlaneUHFVolumeInc, 																name = _('UHF RCU-8150 Volume Increase'),				category = _('Radios Control')},
	{pressed = iCommandPlaneUHFVolumeDec, 																name = _('UHF RCU-8150 Volume Decrease'),				category = _('Radios Control')},
	{down = radio_commands.Switch_OP_MOD,		cockpit_device_id = devices.RSC,	value_down = 0.05, 	name = _('UHF RCU-8150 Operational Mode: OFF'),			category = _('Radios Control')},
	{down = radio_commands.Switch_OP_MOD,		cockpit_device_id = devices.RSC,	value_down = 0.15, 	name = _('UHF RCU-8150 Operational Mode: TEST'),		category = _('Radios Control')},
	{down = radio_commands.Switch_OP_MOD,		cockpit_device_id = devices.RSC,	value_down = 0.35, 	name = _('UHF RCU-8150 Operational Mode: TR+G'),		category = _('Radios Control')},
	{down = radio_commands.Switch_OP_MOD,		cockpit_device_id = devices.RSC,	value_down = 0.45, 	name = _('UHF RCU-8150 Operational Mode: TR'),			category = _('Radios Control')},
	{down = radio_commands.Switch_OP_MOD,		cockpit_device_id = devices.RSC,	value_down = 0.55, 	name = _('UHF RCU-8150 Operational Mode: ADF'),			category = _('Radios Control')},
	{down = radio_commands.Switch_OP_MOD,		cockpit_device_id = devices.RSC,	value_down = 0.65, 	name = _('UHF RCU-8150 Operational Mode: CHNG PRST'),	category = _('Radios Control')},
	{down = radio_commands.Switch_FREQ_MODE,	cockpit_device_id = devices.RSC,	value_down = 0.15, 	name = _('UHF RCU-8150 Frequency Mode: AJ'),			category = _('Radios Control')},
	{down = radio_commands.Switch_FREQ_MODE,	cockpit_device_id = devices.RSC,	value_down = 0.30, 	name = _('UHF RCU-8150 Frequency Mode: MAR'),			category = _('Radios Control')},
	{down = radio_commands.Switch_FREQ_MODE,	cockpit_device_id = devices.RSC,	value_down = 0.45, 	name = _('UHF RCU-8150 Frequency Mode: PRST'),			category = _('Radios Control')},
	{down = radio_commands.Switch_FREQ_MODE,	cockpit_device_id = devices.RSC,	value_down = 0.60, 	name = _('UHF RCU-8150 Frequency Mode: MAN'),			category = _('Radios Control')},
	{down = radio_commands.Switch_FREQ_MODE,	cockpit_device_id = devices.RSC,	value_down = 0.75, 	name = _('UHF RCU-8150 Frequency Mode: 243'),			category = _('Radios Control')},
	{down = radio_commands.Switch_FREQ_MODE,	cockpit_device_id = devices.RSC,	value_down = 0.90, 	name = _('UHF RCU-8150 Frequency Mode: AJ/M'),			category = _('Radios Control')},
	{down = radio_commands.Switch_FREQ_MODE,	cockpit_device_id = devices.RSC,	value_down = 0.00, 	name = _('UHF RCU-8150 Frequency Mode: 121'),			category = _('Radios Control')},
	{down = iCommandPlaneUHFFunctionDialMAIN, 															name = _('UHF RCU-8150 Ancillary Mode Pointer'),		category = _('Radios Control')},
	{down = iCommandPlaneUHFFunctionDialBOTH, 															name = _('UHF RCU-8150 Ancillary Mode Switch'),			category = _('Radios Control')},
	{down = iCommandPlaneUHFFreqModeDialMNL, 	up = iCommandPlaneUHFFunctionDialOFF,					name = _('UHF RCU-8150 LOAD/OFST Switch'),				category = _('Radios Control')},
	
	-- MISCELLANEOUS PANEL
	{down = iCommandPlaneNavChangePanelModeLeft,	name = _('INS Mode Left  (NAV - ALIGN  - OFF)'),				category = _('Miscellaneous Controls')},
	{down = iCommandPlaneNavChangePanelModeRight,	name = _('INS Mode Right (OFF - ALIGN  - NAV)'),				category = _('Miscellaneous Controls')},
	{down = iCommandPlaneNightTVOnOff,				name = _('DMT On/Off Toggle'),									category = _('Miscellaneous Controls')},
	{down = iCommandPlaneRadarOnOff,				name = _('FLIR Power Switch ON/OFF'),									category = _('Miscellaneous Controls')},
	{down = iCommandPlaneRadarUp,					name = _('Mission Computer Mode Up (OFF - AUTO - OVRD)'),		category = _('Miscellaneous Controls')},
	{down = iCommandPlaneRadarDown,					name = _('Mission Computer Mode Down (OVRD - AUTO  - OFF)'),	category = _('Miscellaneous Controls')},
	{down = iCommandPlaneCMSC_PRI,					name = _('Stopwatch Start/Stop toggle'),						category = _('Miscellaneous Controls')},
	{down = iCommandPlaneCMSC_SEP,					name = _('Stopwatch Lap/Reset toggle'),							category = _('Miscellaneous Controls')},
	{down = misc_commands.Switch_FLIR_Power,			cockpit_device_id = devices.NAVFLIR, value_down = 1.0, name = _('FLIR Power Switch ON'), category = _('Miscellaneous Controls')},
	{down = misc_commands.Switch_FLIR_Power,			cockpit_device_id = devices.NAVFLIR, value_down = 0.0, name = _('FLIR Power Switch OFF'), category = _('Miscellaneous Controls')},
	{down = misc_commands.Switch_DMT_Power,				cockpit_device_id = devices.DMT, value_down = 1.0, name = _('DMT Switch ON'), category = _('Miscellaneous Controls')},
	{down = misc_commands.Switch_DMT_Power,				cockpit_device_id = devices.DMT, value_down = 0.0, name = _('DMT Switch OFF'), category = _('Miscellaneous Controls')}, 
	{down = misc_commands.Switch_DP_Mode,				cockpit_device_id = devices.MSC, value_down = 1.0, name = _('Mission Computer Mode OVRD'), category = _('Miscellaneous Controls')},
	{down = misc_commands.Switch_DP_Mode,				cockpit_device_id = devices.MSC, value_down = 0.5, name = _('Mission Computer Mode AUTO'), category = _('Miscellaneous Controls')},              
	{down = misc_commands.Switch_DP_Mode,				cockpit_device_id = devices.MSC, value_down = 0.0, name = _('Mission Computer Mode OFF'), category = _('Miscellaneous Controls')},
	{down = misc_commands.Switch_DP_Mode_AUTO_TOGGLE,	cockpit_device_id = devices.MSC, value_down = 0.0, name = _('Mission Computer Mode AUTO/OFF'), category = _('Miscellaneous Controls')},
	{down = misc_commands.Switch_DP_Mode_OVRD_TOGGLE,	cockpit_device_id = devices.MSC, value_down = 0.0, name = _('Mission Computer Mode OVRD/OFF'), category = _('Miscellaneous Controls')},
	
	-- Navigation Panel
	{down = iCommandHSI_CourseRotaryLeft,																name = _('INS COURSE SET CW'),					category = _('Navigation Control')},
	{down = iCommandHSI_CourseRotaryRight, 																name = _('INS COURSE SET CCW'),					category = _('Navigation Control')},
	{down = misc_commands.Knob_INS_Mode,	cockpit_device_id = devices.NAV_INS,	value_down = 0.0, 	name = _('INS Mode: OFF'),						category = _('Navigation Control')},
	{down = misc_commands.Knob_INS_Mode,	cockpit_device_id = devices.NAV_INS,	value_down = 0.1, 	name = _('INS Mode: SEA ALIGN'),				category = _('Navigation Control')},
	{down = misc_commands.Knob_INS_Mode,	cockpit_device_id = devices.NAV_INS,	value_down = 0.2, 	name = _('INS Mode: GND ALIGN'),				category = _('Navigation Control')},
	{down = misc_commands.Knob_INS_Mode,	cockpit_device_id = devices.NAV_INS,	value_down = 0.3, 	name = _('INS Mode: NAV'),						category = _('Navigation Control')},
	{down = misc_commands.Knob_INS_Mode,	cockpit_device_id = devices.NAV_INS,	value_down = 0.4, 	name = _('INS Mode: IFA'),						category = _('Navigation Control')},
	{down = misc_commands.Knob_INS_Mode,	cockpit_device_id = devices.NAV_INS,	value_down = 0.5, 	name = _('INS Mode: GYRO'),						category = _('Navigation Control')},
	
	-- INTERNAL LIGHTS
	{down = iCommandPlaneMasterCaution,					name = _('Master Warning/Caution Reset'),					category = _('Internal Lights')},
	
	--EXTERNAL LIGHTS
	{down = iCommandPlaneLightsOnOff,					name = _('Exterior Lights Toggle'),							category = _('Exterior Lights')},
	{down = iCommandPlaneNavLights_CodeModeOn,			name = _('Exterior Lights Master Switch OFF-NVG-NORM'),		category = _('Exterior Lights')},
	{down = iCommandPlaneNavLights_CodeModeOff,			name = _('Exterior Lights Master Switch NORM-NVG-OFF'),		category = _('Exterior Lights')},
	{pressed = iCommandPlaneFormationLightsIncrease,	name = _('Formation Lights Knob Brightness Increase'),		category = _('Exterior Lights')},
	{pressed = iCommandPlaneFormationLightsDecrease,	name = _('Formation Lights Knob Brightness Decrease'),		category = _('Exterior Lights')},
	{down = iCommandPlanePositionLightsSteady,			name = _('Position Lights Switch OFF-DIM-BRT'),				category = _('Exterior Lights')},
	{down = iCommandPlanePositionLightsOff,				name = _('Position Lights Switch BRT-DIM-OFF'),				category = _('Exterior Lights')},
	{down = iCommandPlaneAntiCollisionLights,			name = _('Anti-Collision Lights Toggle'),					category = _('Exterior Lights')},
	{down = iCommandPlaneLGPTaxiLight,					name = _('Auxiliary (Taxi) Light Toggle'),					category = _('Exterior Lights')},
	{down = iCommandPlaneLGPLandLight,          name = _('Landing Light Switch Up (OFF-HVR-APP)'),        category = _('Exterior Lights')},
	{down = iCommandPlaneLGPLightsOff,          name = _('Landing Light Switch Down (APP-HVR-OFF)'),        category = _('Exterior Lights')},
	{down = iCommandPlaneRotorTipLights, value_down = 1, name = _('Air Refueling Probe Light ON'),       category = _('Exterior Lights')},
	{down = iCommandPlaneRotorTipLights, value_down = 0, name = _('Air Refueling Probe Light OFF'),       category = _('Exterior Lights')},
	{down = ext_light_commands.AR_PROBE_LT_TOGGLE,			cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Air Refueling Probe Light TOGGLE'),  category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_POS_LT_BRT_TOGGLE,	cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Position Lights OFF/BRT Toggle'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_POS_LT_DIM_TOGGLE,	cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Position Lights OFF/DIM Toggle'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_ANTI_COLL_LT,			cockpit_device_id = devices.LTEXT, value_down = 1, name = _('Anti Collision Lights ON'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_ANTI_COLL_LT,			cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Anti Collision Lights OFF'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_AUX_LT,				cockpit_device_id = devices.LTEXT, value_down = 1, name = _('Auxiliary (Taxi) Light ON'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_AUX_LT,				cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Auxiliary (Taxi) Light OFF'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_EXT_LT_NORM_TOGGLE,	cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Exterior Lights Master Switch NORM/OFF'), category = _('Exterior Lights')}, 
	{down = ext_light_commands.Switch_EXT_LT_NVG_TOGGLE,	cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Exterior Lights Master Switch NVG/OFF'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_EXT_LT_NORM, cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Exterior Lights Master Switch NORM'), category = _('Exterior Lights')}, 
  {down = ext_light_commands.Switch_EXT_LT_NVG,  cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Exterior Lights Master Switch NVG'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_LANDING_LT,			cockpit_device_id = devices.LTEXT, value_down = 0.5, name = _('Landing Light HVR'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_LANDING_LT,			cockpit_device_id = devices.LTEXT, value_down = 1.0, name = _('Landing Light APP'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_LANDING_LT,			cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Landing Light OFF'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_LANDING_LT_APP_TOGGLE,cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Landing Light APP/OFF'), category = _('Exterior Lights')},
	{down = ext_light_commands.Switch_LANDING_LT_HVR_TOGGLE,cockpit_device_id = devices.LTEXT, value_down = 0, name = _('Landing Light HVR/OFF'), category = _('Exterior Lights')},
	
	
	-- Ground Adjustment (Kneeboard)
	{down = iCommandPlaneCircuitBreaker_21,		value_down = 1,	name = _('Change Top Front Left ECM Dispenser Load (Chaff/Flares)'),	category = {_('Ground Adjustments')}},
	{down = iCommandPlaneCircuitBreaker_22,		value_down = 1,	name = _('Change Top Front Right ECM Dispenser Load (Chaff/Flares)'),	category = {_('Ground Adjustments')}},
	{down = iCommandPlaneCircuitBreaker_23,		value_down = 1,	name = _('Change Top Rear Left ECM Dispenser Load (Chaff/Flares)'),		category = {_('Ground Adjustments')}},
	{down = iCommandPlaneCircuitBreaker_24,		value_down = 1,	name = _('Change Top Rear Right ECM Dispenser Load (Chaff/Flares)'),	category = {_('Ground Adjustments')}},
	{down = iCommandPlaneCircuitBreaker_25,		value_down = 1,	name = _('Change Bottom Left ECM Dispenser Load (Chaff/Flares)'),		category = {_('Ground Adjustments')}},
	{down = iCommandPlaneCircuitBreaker_26,		value_down = 1,	name = _('Change Bottom Right ECM Dispenser Load (Chaff/Flares)'),		category = {_('Ground Adjustments')}},
	{down = iCommandPlaneCircuitBreaker_29,		value_down = 1,	name = _('AN/AVS-9 NVG Case (Load/Unload)'),							category = {_('Ground Adjustments')}},
	{down = iCommandPlaneCircuitBreaker_30,		value_down = 1,	name = _('Change FF Rocket Fire Mode (Single/Ripple)'),					category = {_('Ground Adjustments')}},
	{down = iCommandPlane_HARS_SyncButton,		value_down = 1,	name = _('Check MAP for Target Locations'),								category = {_('Ground Adjustments')}},
	{down = iCommandPlane_SPU9_radio_change,	value_down = 1,	name = _('Change Mission Route Map Page'),								category = {_('Ground Adjustments')}},
	
	-- Cheat
	{down = iCommandEnginesStart,			name = _('Start Procedure'),		category = _('Keyboard Macros')},
    {down = iCommandEnginesStop,			name = _('Stop Procedure'),			category = _('Keyboard Macros')},
	{down = iCommandPlane_AAP_SteerSw_Up,	name = _('TPOD Video Zoom In'),		category = _('Keyboard Macros')},
    {down = iCommandPlane_AAP_SteerSw_Down,	name = _('TPOD Video Zoom Out'),	category = _('Keyboard Macros')},
	
	-- DEBUG
	{down = iCommandEasyRadarScaleUp,  up = iCommandRALT_Test_up,  name = _('AOA Indicator Up'), category = _('DEBUG')},
	{down = iCommandEasyRadarScaleOut, up = iCommandRALT_Test_up, name = _('AOA Indicator Down'), category = _('DEBUG')},
	
	}
)

join(res.axisCommands,{

{combos = defaultDeviceAssignmentFor("roll")  ,  action = iCommandPlaneRoll		   , name = _('Roll')},
{combos = defaultDeviceAssignmentFor("pitch") ,  action = iCommandPlanePitch	   , name = _('Pitch')},
{combos = defaultDeviceAssignmentFor("rudder"),  action = iCommandPlaneRudder	   , name = _('Rudder')},
{combos = defaultDeviceAssignmentFor("thrust"),  action = iCommandPlaneThrustCommon, name = _('Thrust')},
{action = iCommandPlaneCollective,  name = _('Nozzle Angle')},
{action = iCommandWheelBrake,		name = _('Wheel Brakes')},
{action = iCommandLeftWheelBrake,	name = _('Wheel Brake Left')},
{action = iCommandRightWheelBrake,	name = _('Wheel Brake Right')},
{action = iCommandPlaneThrustRight,	name = _('Nozzle STO Stop')},

--HOTAS TDC
{action = iCommandPlaneSelecterHorizontalAbs, name = _('TDC Slew Horizontal')},
{action = iCommandPlaneSelecterVerticalAbs	, name = _('TDC Slew Vertical')},

}) 


return res